package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import java.util.ArrayList;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityAppUpdateBinding;
import app.firezone.synk.network.model.AppModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AppUpdateActivity extends AppCompatActivity {


    ActivityAppUpdateBinding binding;

    String updateLink;

    Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding  = ActivityAppUpdateBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        // In onCreate
        binding.updateBtn.setEnabled(false);

        dialog = new Dialog(this);
        dialog.setContentView(R.layout.loading_dialog);
        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(false);
        }
        dialog.show();

        loadData();

        binding.updateBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (updateLink != null && !updateLink.isEmpty()) {
                    Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(updateLink));
                    startActivity(browserIntent);
                } else {
                    Toast.makeText(AppUpdateActivity.this, "Update link not available yet. Please try again shortly.", Toast.LENGTH_SHORT).show();
                }
            }
        });

    }
    private void loadData() {
        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();

        call.enqueue(new Callback<ArrayList<AppModel>>() {
            @Override
            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    AppModel model = response.body().get(0); // Fetch first AppModel object
                    updateLink = model.getUpdateLink();
                    binding.updateBtn.setEnabled(true);

                } else {
                    Toast.makeText(AppUpdateActivity.this, "No data found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                dialog.dismiss();
                Toast.makeText(AppUpdateActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }


}